
//Program to find out bus admittance matrix of a power system of any size//
//This program requires user input. A sample problem with user input and output is available in the result file//
//Scilab Version 5.5.2 ; OS:Windows
clc;
clear;
linedata=input('Enter line data in order of strt bus,end bus,series resistance,series reactance,shunt susceptance:')
sb=linedata(:,1)  //Starting bus number of all the lines stored in variable sb
eb=linedata(:,2)  //Ending bus number of all the lines stored in variable eb
lz=linedata(:,3)+linedata(:,4)*%i;  //lineimpedance=R+jX
sa=-linedata(:,5)*%i;   //shunt admittance=-jB
nb=max(max(sb,eb));
ybus=zeros(nb,nb);
for i=1:length(sb)
    m=sb(i);
    n=eb(i);
    ybus(m,m)=ybus(m,m)+1/lz(i)+sa(i);
    ybus(n,n)=ybus(n,n)+1/lz(i)+sa(i);
    ybus(m,n)=-1/lz(i);
    ybus(n,m)=ybus(m,n);
end
disp(ybus,'The Bus Admittance matrix is:')

//SAMPLE INPUT:

//Enter line data in order of strt bus,end bus,series resistance,series reactance,shunt susceptance:[1 2 0.02 0.04 0;1 3 0.01 0.03 0;2 3 0.0125 0.025 0]
 
 //OUTPUT:
 //The Bus Admittance matrix is:   
 
//    20. - 50.i  - 10. + 20.i  - 10. + 30.i  
//  - 10. + 20.i    26. - 52.i  - 16. + 32.i  
//  - 10. + 30.i  - 16. + 32.i    26. - 62.i 

